# Hallucination Perspective

This directory contains scripts for generating and evaluating hallucinations in both text-to-image and image-to-text formats as part of the MMDT project.

## Directory Structure

- `generate_image_to_text.py`: Script to generate text descriptions from images.
- `generate_text_to_image.py`: Script to generate images from text prompts.
- `eval_image_to_text.py`: Script to evaluate the generated text descriptions.
- `eval_text_to_image.py`: Script to evaluate the generated images.
- `utils.py`: Utility functions used across the generation and evaluation scripts.

## Usage

### Generating Results

To generate results, you need to specify the model, scenario, and task you want to execute. Here are the command-line arguments you need to provide:

```
python generate_image_to_text.py --model_id <model_id> --scenario <scenario> --task <task>
python generate_text_to_image.py --model_id <model_id> --scenario <scenario> --task <task>
```

### Evaluating Results

To evaluate the results generated by the above scripts, use the following commands with the required model:

```
python eval_image_to_text.py --model_id <model_id> --scenario <scenario> --task <task>
python eval_text_to_image.py --model_id <model_id> --scenario <scenario> --task <task>
```

#### Arguments

- `--model_id`: Model ID whose results are to be evaluated (required).
- `--scenario`: Scenario type, defaults to 'natural'.
- `--task`: Type of task to be evaluated, defaults to 'identification'.
